/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting;

import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.library.recipe.casting.ICastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.ItemCastingRecipe;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class ItemCastingRecipeBuilder
extends AbstractRecipeBuilder<ItemCastingRecipeBuilder> {
    private final ItemOutput result;
    private final ItemCastingRecipe.Serializer<?> recipeSerializer;
    private class_1856 cast = class_1856.field_9017;
    private FluidIngredient fluid = FluidIngredient.EMPTY;
    private int coolingTime = -1;
    private boolean consumed = false;
    private boolean switchSlots = false;

    public static ItemCastingRecipeBuilder basinRecipe(ItemOutput result) {
        return ItemCastingRecipeBuilder.castingRecipe(result, (ItemCastingRecipe.Serializer)TinkerSmeltery.basinRecipeSerializer.get());
    }

    public static ItemCastingRecipeBuilder retexturedBasinRecipe(ItemOutput result) {
        return ItemCastingRecipeBuilder.castingRecipe(result, (ItemCastingRecipe.Serializer)TinkerSmeltery.retexturedBasinRecipeSerializer.get());
    }

    public static ItemCastingRecipeBuilder basinRecipe(class_1935 resultIn) {
        return ItemCastingRecipeBuilder.basinRecipe(ItemOutput.fromItem(resultIn));
    }

    public static ItemCastingRecipeBuilder basinRecipe(class_6862<class_1792> result) {
        return ItemCastingRecipeBuilder.basinRecipe(ItemOutput.fromTag(result, 1));
    }

    public static ItemCastingRecipeBuilder tableRecipe(ItemOutput resultIn) {
        return ItemCastingRecipeBuilder.castingRecipe(resultIn, (ItemCastingRecipe.Serializer)TinkerSmeltery.tableRecipeSerializer.get());
    }

    public static ItemCastingRecipeBuilder retexturedTableRecipe(ItemOutput resultIn) {
        return ItemCastingRecipeBuilder.castingRecipe(resultIn, (ItemCastingRecipe.Serializer)TinkerSmeltery.retexturedTableRecipeSerializer.get());
    }

    public static ItemCastingRecipeBuilder tableRecipe(class_1935 resultIn) {
        return ItemCastingRecipeBuilder.tableRecipe(ItemOutput.fromItem(resultIn));
    }

    public static ItemCastingRecipeBuilder tableRecipe(class_6862<class_1792> result) {
        return ItemCastingRecipeBuilder.tableRecipe(ItemOutput.fromTag(result, 1));
    }

    public ItemCastingRecipeBuilder setFluid(class_6862<class_3611> tagIn, long amount) {
        return this.setFluid(FluidIngredient.of(tagIn, amount));
    }

    public ItemCastingRecipeBuilder setFluid(FluidIngredient fluid) {
        this.fluid = fluid;
        return this;
    }

    public ItemCastingRecipeBuilder setCoolingTime(int temperature, long amount) {
        return this.setCoolingTime(ICastingRecipe.calcCoolingTime(temperature, amount));
    }

    public ItemCastingRecipeBuilder setFluidAndTime(FluidStack fluidStack) {
        this.fluid = FluidIngredient.of(fluidStack);
        if (this.coolingTime == -1) {
            this.coolingTime = ICastingRecipe.calcCoolingTime(fluidStack);
        }
        return this;
    }

    public ItemCastingRecipeBuilder setFluidAndTime(int temperature, class_6862<class_3611> tagIn, long amount) {
        this.setFluid(tagIn, amount);
        this.setCoolingTime(temperature, amount);
        return this;
    }

    public ItemCastingRecipeBuilder setFluidAndTime(class_3611 fluid, class_6862<class_3611> tag, long amount) {
        return this.setFluidAndTime(FluidVariantAttributes.getTemperature((FluidVariant)FluidVariant.of((class_3611)fluid)) - 300, tag, amount);
    }

    public ItemCastingRecipeBuilder setFluidAndTime(FluidObject<?> fluid, boolean forgeTag, long amount) {
        return this.setFluidAndTime((class_3611)fluid.get(), forgeTag ? fluid.getForgeTag() : fluid.getLocalTag(), amount);
    }

    public ItemCastingRecipeBuilder setFluidAndTime(FluidObject<?> fluid, long amount) {
        return this.setFluidAndTime(fluid, false, amount);
    }

    public ItemCastingRecipeBuilder setCast(class_6862<class_1792> tagIn, boolean consumed) {
        return this.setCast(class_1856.method_8106(tagIn), consumed);
    }

    public ItemCastingRecipeBuilder setCast(class_1935 itemIn, boolean consumed) {
        return this.setCast(class_1856.method_8091((class_1935[])new class_1935[]{itemIn}), consumed);
    }

    public ItemCastingRecipeBuilder setCast(class_1856 ingredient, boolean consumed) {
        this.cast = ingredient;
        this.consumed = consumed;
        return this;
    }

    public ItemCastingRecipeBuilder setSwitchSlots() {
        this.switchSlots = true;
        return this;
    }

    @Override
    public void save(Consumer<class_2444> consumerIn) {
        this.save(consumerIn, Objects.requireNonNull(class_7923.field_41178.method_10221((Object)this.result.get().method_7909())));
    }

    @Override
    public void save(Consumer<class_2444> consumer, class_2960 id) {
        if (this.fluid == FluidIngredient.EMPTY) {
            throw new IllegalStateException("Casting recipes require a fluid input");
        }
        if (this.coolingTime < 0) {
            throw new IllegalStateException("Cooling time is too low, must be at least 0");
        }
        class_2960 advancementId = this.buildOptionalAdvancement(id, "casting");
        consumer.accept(new Result(id, advancementId));
    }

    private ItemCastingRecipeBuilder(ItemOutput result, ItemCastingRecipe.Serializer<?> recipeSerializer) {
        this.result = result;
        this.recipeSerializer = recipeSerializer;
    }

    public static ItemCastingRecipeBuilder castingRecipe(ItemOutput result, ItemCastingRecipe.Serializer<?> recipeSerializer) {
        return new ItemCastingRecipeBuilder(result, recipeSerializer);
    }

    public ItemCastingRecipeBuilder setCoolingTime(int coolingTime) {
        this.coolingTime = coolingTime;
        return this;
    }

    private class Result
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public Result(@Nullable class_2960 ID, class_2960 advancementID) {
            super(ID, advancementID);
        }

        public class_1865<?> method_17800() {
            return ItemCastingRecipeBuilder.this.recipeSerializer;
        }

        public void method_10416(JsonObject json) {
            if (!ItemCastingRecipeBuilder.this.group.isEmpty()) {
                json.addProperty("group", ItemCastingRecipeBuilder.this.group);
            }
            if (ItemCastingRecipeBuilder.this.cast != class_1856.field_9017) {
                json.add("cast", ItemCastingRecipeBuilder.this.cast.method_8089());
                if (ItemCastingRecipeBuilder.this.consumed) {
                    json.addProperty("cast_consumed", Boolean.valueOf(true));
                }
            }
            if (ItemCastingRecipeBuilder.this.switchSlots) {
                json.addProperty("switch_slots", Boolean.valueOf(true));
            }
            json.add("fluid", ItemCastingRecipeBuilder.this.fluid.serialize());
            json.add("result", ItemCastingRecipeBuilder.this.result.serialize());
            json.addProperty("cooling_time", (Number)ItemCastingRecipeBuilder.this.coolingTime);
        }
    }
}

